﻿using System.Collections.Generic;

namespace Hims.Api.Controllers
{
    using System;
    using System.Threading.Tasks;
    using Domain.Services;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Labs = Shared.UserModels.ProgressReport.Labs;
    using Utilities;
    using Hims.Shared.UserModels.Common;
    using Hims.Api.Models;

    /// <inheritdoc />
    [Authorize]
    [Route("api/progress-report-lab")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class ProgressReportLabController : BaseController
    {
        /// <summary>
        /// The coupon services.
        /// </summary>
        private readonly IProgressReportLabService service;

        /// <summary>
        /// The auditlog services.
        /// </summary>
        private readonly IAuditLogService auditLogServices;

        /// <summary>
        /// the provider service
        /// </summary>
        private readonly IProviderService providerServices;

        /// <summary>
        /// the provider service
        /// </summary>
        private readonly IPatientService patientServices;

        /// <inheritdoc />
        public ProgressReportLabController(IProgressReportLabService service, IAuditLogService auditLogServices, IProviderService providerServices, IPatientService patientServices)
        {
            this.service = service;
            this.auditLogServices = auditLogServices;
            this.providerServices = providerServices;
            this.patientServices = patientServices;
        }

        /// <summary>
        /// The add coupon.
        /// </summary>
        /// <param name="searchParam"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - Coupon added successfully.
        /// - 409 - Coupon already exist.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpGet]
        [Route("labs-async")]
        public async Task<ActionResult> FetchMasterMedicationAsync(string searchParam, [FromHeader] LocationHeader header)
        {
            var locationId = Convert.ToInt32(header.LocationId);

            try
            {
                var response = await this.service.FetchMasterLabsAsync(searchParam,locationId);
                return Ok(response ?? new List<Labs.MasterViewModel>());
            }
            catch (Exception)
            {
                return Ok(new List<Labs.MasterViewModel>());
            }
        }

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch")]
        public async Task<ActionResult> FetchAsync([FromBody] Labs.FilterModel model, [FromHeader] LocationHeader header)
        {
            
            try
            {
                model.LocationId= Convert.ToInt32(header.LocationId);
                var response = await this.service.FetchAsync(model);
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Success,
                    Data = response
                });
            }
            catch (Exception e)
            {
                return Ok(new GenericResponse
                {
                    Status = GenericStatus.Error,
                    Message = e.Message
                });
            }
        }
    }
}